import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, concatenate_objects, create_dataframe, bind_dataframe, reset_index, rename_columns, access_dataframe_loc, join_dataframes, get_max, assert_series, extract_unique_values, is_a_null_df, visit_by_index, fetch_df_size, iterate_rows, fetch_column, create_multiindex_from_product, convert_multiindex_to_dataframe, remove_labels, fill_missing_values


def calculate_head_to_head_win_rate(data):
    unique_players = extract_unique_values(concatenate_objects(fetch_column(data, 'Player_1'), fetch_column(data, 'Player_2')))

    total_matches = reset_index(fetch_df_size(bind_dataframe(data, ['Player_1', 'Player_2'])), drop=False)
    total_matches = rename_columns(total_matches, columns={0: 'count_total'})

    player_wins = fetch_df_size(bind_dataframe(data[assert_series(data['Winner'], data['Player_1'], 'equality')], ['Player_1', 'Player_2']))
    player_wins = reset_index(player_wins, drop=False)
    player_wins = rename_columns(player_wins, {0: 'count_wins'})

    multiindex = create_multiindex_from_product([unique_players, unique_players], names=['Player', 'Opponent'])
    all_pairs = convert_multiindex_to_dataframe(multiindex, index=False)
    all_pairs = all_pairs[assert_series(all_pairs['Player'], all_pairs['Opponent'], 'inequality')]

    h2h_win_rates = remove_labels(join_dataframes(all_pairs, total_matches, left_on=['Player', 'Opponent'], right_on=['Player_1', 'Player_2'], how='left'), columns=['Player_1', 'Player_2'])
    h2h_win_rates = remove_labels(join_dataframes(h2h_win_rates, player_wins, left_on=['Player', 'Opponent'], right_on=['Player_1', 'Player_2'], how='left'), columns=['Player_1', 'Player_2'])

    fill_missing_values(h2h_win_rates['count_wins'], value=0, inplace=True)
    fill_missing_values(h2h_win_rates['count_total'], value=1, inplace=True)

    h2h_win_rates['Head-to-Head Win Rate'] = fetch_column(h2h_win_rates, 'count_wins') / fetch_column(h2h_win_rates, 'count_total')
    h2h_win_rates = remove_labels(h2h_win_rates, columns=['count_total', 'count_wins'])

    return h2h_win_rates


def estimate_probability(player_1_win_rate, player_2_win_rate, h2h_player_1_win_rate, h2h_player_2_win_rate, performance_weight=0.7, h2h_weight=0.3):
    if player_1_win_rate + player_2_win_rate == 0:
        player_1_win_rate = player_2_win_rate = 0.5

    if h2h_player_1_win_rate + h2h_player_2_win_rate == 0:
        h2h_player_1_win_rate = h2h_player_2_win_rate = 0.5

    weighted_player_1_win_rate = performance_weight * player_1_win_rate + h2h_weight * h2h_player_1_win_rate
    weighted_player_2_win_rate = performance_weight * player_2_win_rate + h2h_weight * h2h_player_2_win_rate
    total_weighted_win_rate = weighted_player_1_win_rate + weighted_player_2_win_rate

    player_1_probability = weighted_player_1_win_rate / total_weighted_win_rate
    player_2_probability = weighted_player_2_win_rate / total_weighted_win_rate

    return player_1_probability, player_2_probability


def update_odds(match_id, performance_weight, h2h_weight, data, h2h_win_rates):
    player_1 = access_dataframe_loc(data, match_id, 'Player_1')
    player_2 = access_dataframe_loc(data, match_id, 'Player_2')

    player_1_win_rate = access_dataframe_loc(player_stats, assert_series(fetch_column(player_stats, 'Opponent'), player_1, 'equality'), 'Win Rate')
    player_2_win_rate = access_dataframe_loc(player_stats, assert_series(fetch_column(player_stats, 'Opponent'), player_2, 'equality'), 'Win Rate')

    player_1_win_rate = visit_by_index(player_1_win_rate, 0) if not is_a_null_df(player_1_win_rate) else 0
    player_2_win_rate = visit_by_index(player_2_win_rate, 0) if not is_a_null_df(player_2_win_rate) else 0

    h2h_player_1_win_rate = access_dataframe_loc(h2h_win_rates, assert_series(fetch_column(h2h_win_rates, 'Opponent'), player_2, 'equality'), 'Head-to-Head Win Rate')
    h2h_player_2_win_rate = access_dataframe_loc(h2h_win_rates, assert_series(fetch_column(h2h_win_rates, 'Opponent'), player_1, 'equality'), 'Head-to-Head Win Rate')

    h2h_player_1_win_rate = visit_by_index(h2h_player_1_win_rate, 0) if not is_a_null_df(h2h_player_1_win_rate) else 0
    h2h_player_2_win_rate = visit_by_index(h2h_player_2_win_rate, 0) if not is_a_null_df(h2h_player_2_win_rate) else 0

    player_1_probability, player_2_probability = estimate_probability(player_1_win_rate, player_2_win_rate, h2h_player_1_win_rate, h2h_player_2_win_rate, performance_weight, h2h_weight)
    max_odd_1 = get_max(fetch_column(data, 'Odd_1'))
    max_odd_2 = get_max(fetch_column(data, 'Odd_2'))

    if player_1_probability == 0:
        updated_odd_1 = max_odd_1
    else:
        updated_odd_1 = 1 / player_1_probability

    if player_2_probability == 0:
        updated_odd_2 = max_odd_2
    else:
        updated_odd_2 = 1 / player_2_probability

    return updated_odd_1, updated_odd_2

# Calculate head-to-head win rates
h2h_win_rates = calculate_head_to_head_win_rate(atp_tennis)

# Initialize an empty DataFrame for storing the results
updated_odds_df = create_dataframe(data=[], columns=['Match ID', 'Original Odd_1', 'Original Odd_2', 'Updated Odd_1', 'Updated Odd_2'])

# Loop through the affected matches
for match_id in federer_match_ids:
    # Update the odds for the match
    updated_odd_1, updated_odd_2 = update_odds(match_id, 0.7, 0.3, atp_tennis, h2h_win_rates)

    # Append the results to the DataFrame
    original_odd_1 = access_dataframe_loc(atp_tennis, match_id, 'Odd_1')
    original_odd_2 = access_dataframe_loc(atp_tennis, match_id, 'Odd_2')
    updated_odds_df = concatenate_objects(updated_odds_df, create_dataframe(data={'Match ID': [match_id], 'Original Odd_1': [original_odd_1], 'Original Odd_2': [original_odd_2], 'Updated Odd_1': [updated_odd_1], 'Updated Odd_2': [updated_odd_2]}), reset_index_flag=True)

print(updated_odds_df)
pickle.dump(updated_odds_df,open("./ref_result/updated_odds_df.pkl","wb"))